﻿using System;
using System.Collections.Generic;
using System.Text;

namespace IndianHealthService.BMXNet.EHR
{
    /// <summary>
    /// To support the HelpFile framework in the EHR menu, your component must
    /// implement this interface.
    /// </summary>
    public interface IEhrComponent:IDisposable {

        /// <summary>
        /// The name of the compiled Windows help file (.chm).  
        /// </summary>
        /// <remarks>
        /// See the EHR/VueCentric integration partial class for details on specifying a HelpFile
        /// </remarks>
        String HelpFile { get; }

        /// <summary>
        /// Not currently used
        /// </summary>
        String HelpContext { get; }


        /// <summary>
        /// Not currently used
        /// </summary>
        String HelpString { get; }
    }
}
